declare namespace rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#";
declare namespace foaf="http://xmlns.com/foaf/0.1/";
declare namespace rdfs="http://www.w3.org/2000/01/rdf-schema#";
declare namespace bio="http://purl.org/vocab/bio/0.1/";

let $person := ./rdf:RDF/foaf:Person
let $person := if ($person) then $person else ./rdf:RDF/foaf:Group
let $fullName := string($person/foaf:name/text())
let $name := if ($fullName) then $fullName else
	let $first := string($person/foaf:firstName/text())
	let $last := string($person/foaf:surname/text())
	return if ($first and $last) then concat($first, " ", $last)
			else if ($first) then $first
			else if ($last) then $last
			else ()
let $nick := string($person/foaf:nick/text())
let $image := string($person/foaf:img/@rdf:resource)
let $image := if ($image) then $image else string($person/foaf:depiction/@rdf:resource)
let $image := if ($image) then $image else string($person/foaf:logo/@rdf:resource)
let $bio := string($person/bio:olb/text())
let $email := string($person/foaf:mbox/@rdf:resource)
let $aimChatID := string($person/foaf:aimChatID/text())
let $homepage := string($person/foaf:homepage/@rdf:resource)
let $weblog := string($person/foaf:weblog/@rdf:resource)
let $interests := for $interest in $person//foaf:interest/@rdf:resource
    return string($interest)
let $friends := $person//foaf:knows/foaf:Person
let $members := $person//foaf:member/foaf:Person
let $friends := ($friends, $members)
let $knows := for $friend in $friends
	let $friendName := string($friend/foaf:name/text())
    let $friendNick := string($friend/foaf:nick/text())
    let $friendName := if ($friendName) then $friendName else $friendNick
	let $friendHomepage := string($friend/foaf:homepage/@rdf:resource)
    let $friendWeblog := string($friend/foaf:weblog/@rdf:resource)
    let $friendHomepage := if ($friendHomepage) then $friendHomepage else $friendWeblog
	let $seeAlso := string($friend/rdfs:seeAlso/@rdf:resource)
	
	(: order is important -- check enum definitions :)	
	return element friend {
			element name {normalize-space($friendName)},
			element homepage {normalize-space($friendHomepage)},
			element seeAlso {normalize-space($seeAlso)}
		}

(: order is important -- check enum definitions :)		
return element person {
		element name {normalize-space($name)},
		element nick {normalize-space($nick)},
		element image {$image},
		element email {normalize-space($email)},
		element aimChatID {normalize-space($aimChatID)},
		element homepage {normalize-space($homepage)},
		element weblog {normalize-space($weblog)},
		element bio {normalize-space($bio)},
		element interests {$interests},
		element knows {$knows}
	}
